define(['modules/preferences/preferences-popup-view'], function(PreferencesView) {
    'use strict';

    describe('Preferences Popup View', function() {
        var view;
        var $view;

        // TODO: upgrade Jasmine, change to beforeAll
        beforeEach(function() {
            spyOn(PreferencesView.prototype, 'saveEmailPreferences');
            view = new PreferencesView({elAfterClose: $('.element-for-focus')});

            $('body').append('<a class="element-for-focus" href="#"></a>');

            view.render();
            $view = view.$el;
        });

        afterEach(function() {
            view.destroy();
            $('.element-for-focus').remove();
        });

        it('has a heading', function() {
            expect($view.find('h2').text()).toEqual('Preferences');
        });

        it('has Save and Cancel buttons', function() {
            expect($view.find('button, a[role=button]').length).toEqual(2);

            expect($view.find('.popup-continue-btn').attr('id')).toEqual('preferences-save-btn');
            expect($view.find('#preferences-save-btn').text()).toEqual('Save');

            expect($view.find('.popup-return-btn').attr('id')).toEqual('preferences-cancel-btn');
            expect($view.find('#preferences-cancel-btn').text()).toEqual('Cancel');
        });

        it('has the Save button before the Cancel button', function() {
            expect($view.find('#preferences-save-btn + #preferences-cancel-btn').length).toEqual(1);
        });

        it('calls saveEmailPreferences when the Save button is clicked', function() {
            $view.find('#preferences-save-btn').click();
            expect(view.saveEmailPreferences).toHaveBeenCalled();
        });
    });
});
